
#ifndef CRYS_HOST_TST_DH
#define CRYS_HOST_TST_DH

/***************************************************************** 
*  @file CRYS_HOST_TST_DH.h
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEPQA_DH_PKCS3         
* 
* Inputs:
* Generator_ptr 		- Pointer to the Generator octet string
* GeneratorSize 		- Size of the Generator String (in bytes)
* Prime_ptr 			- Pointer to the Prime octet string
* PrimeSize 			- Size of the Prime string (in bytes)
* L 					- Relevant only for PKCS#3, the private value length in bits
*	If L != 0 then - force the private key to be 2^(L-1) <= Prv < 2^l
*	if L 0 then: 0< Prv < P-1
*	In ANSI X9.42 L is irrelevant  
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes Diffie-Hellman key agreement 
*  scheme according to PKCS#3  
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************************/                                
EXPORT_C CRYSError_t SEPQA_DH_PKCS3(
                           DxUint8_t   *Generator_ptr,
						   DxUint16_t   GeneratorSize,
						   DxUint8_t   *Prime_ptr,
						   DxUint16_t   PrimeSize,
						   DxUint16_t   L,
						   DxUint8_t   *FailureFunctionNameOut_ptr,
                           DxUint32_t   FuncNameMaxSize);
                           
/***********************************************************************
* Function Name:                                                           
*  SEPQA_DH_ANSI942         
* 
* Inputs:
* Generator_ptr 		- Pointer to the Generator octet string
* GeneratorSize 		- Size of the Generator String (in bytes)
* Prime_ptr 			- Pointer to the Prime octet string
* PrimeSize 			- Size of the Prime string (in bytes)
* Q_ptr 				- Relevant only for ANSI X9.42 - Pointer to the Q octet string
*							1<= Prv <= q-1   or   1< Prv < q-1
* QSize	 			    - Relevant only for ANSI X9.42 - Size of the Q string (in bytes)  				 				  
* SecretDataGenType     - secret data gen type
* KeyGetSecretKeyType   - get secret key type
* KeyLenInBits          - key len in bits
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes Diffie-Hellman key agreement 
*  scheme according to ANSI942  
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************************/                                
EXPORT_C CRYSError_t SEPQA_DH_ANSI942(
                           DxUint8_t   *Generator_ptr,
						   DxUint16_t   GeneratorSize,
						   DxUint8_t   *Prime_ptr,
						   DxUint16_t   PrimeSize,
						   DxUint8_t   *Q_ptr,
						   DxUint16_t   QSize,
						   DxUint16_t   SecretDataGenType,
						   DxUint16_t   KeyGetSecretKeyType,
						   DxUint16_t	KeyLenInBits,
						   DxUint8_t   *FailureFunctionNameOut_ptr,
                           DxUint32_t   FuncNameMaxSize);
 									          						             					
#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_DH */
